from builtins import object, str
# from os import system as os_system
from os import walk as os_walk
from os import listdir, system, stat

from Components.ActionMap import ActionMap
from Components.Label import Label
from Components.MenuList import MenuList
from Components.ScrollLabel import ScrollLabel
from Plugins.Plugin import PluginDescriptor
from Screens.MessageBox import MessageBox
from Screens.Screen import Screen
from Tools.Directories import fileExists
from Tools.LoadPixmap import LoadPixmap
from enigma import eTimer, RT_HALIGN_LEFT, RT_VALIGN_CENTER, eListboxPythonMultiContent, gFont, getDesktop

from . import _


# Edited by Franc 26.05.2016 - ECMInfo, skin, description stuff
# Edited by Terra 31.05.2016 - make it translateable
# Franc 25.07.2017 - New Enigma; PurE2 stuff
# Franc 20.01.2018 - New stuff
# 2022 - Franc, some fixes


def Check_Softcam():
	found = False
	try:
		for x in listdir('/usr/script/cam'):
			if x.find('.sh') > -1:
				found = True
				break
		return found
	except Exception as e:
		print(e)
		return


def startSetup(menuid):
	if menuid != "system":
		return []
	return [(_("PurCamd Manager "), PurCamdManager, "cam_setup", 100)]


def PurCamdManager(session, **kwargs):
	session.open(DreamCC)


def Plugins(**kwargs):
	list = []
	if Check_Softcam() is True:
		list.append(PluginDescriptor(name=_("PurCamd Manager"), description=_("Cam Manager"), where=PluginDescriptor.WHERE_MENU, fnc=startSetup))
		list.append(PluginDescriptor(name=_('PurCamd Manager'), where=PluginDescriptor.WHERE_EXTENSIONSMENU, fnc=PurCamdManager))
		# za autostart (nakon reboot-a):
		# Ovo bas i nije ok mjesto za pozvati autostart, ali bumo videli kako ce sljakati
		list.append(PluginDescriptor(where=PluginDescriptor.WHERE_AUTOSTART, fnc=autostart))
	return list


def autostart(reason, **kwargs):
	global DreamCC_auto
	if reason == 0:
		DreamCC_auto = DreamCCAuto()


# def main(session,**kwargs):
# session.open(DreamCC)

# def Plugins(**kwargs):
# return [PluginDescriptor(name="DreamCC", description=_("Cammanager"), fnc=main),
# PluginDescriptor(where = PluginDescriptor.WHERE_AUTOSTART, fnc = autostart)]


def DreamCCExtra(name, index, isActive=False):
	res = [index]

	if isActive:
		png = LoadPixmap("/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/green_small.png")
		IsStarted = True
	else:
		png = LoadPixmap("/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/red_small.png")

	# Check skin
	if Skn == "FHD":
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 30, 5, 800, 35, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, name))
		res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 10, 17, 14, 14, png))
	elif Skn == "HD":
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 30, 5, 500, 24, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, name))
		res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 10, 10, 14, 14, png))
	else:
		res.append((eListboxPythonMultiContent.TYPE_TEXT, 30, 5, 200, 24, 0, RT_HALIGN_LEFT | RT_VALIGN_CENTER, name))
		res.append((eListboxPythonMultiContent.TYPE_PIXMAP_ALPHATEST, 10, 10, 14, 14, png))

	return res


class DCCMenu(MenuList):
	def __init__(self, list, selection=0, enableWrapAround=True):
		MenuList.__init__(self, list, enableWrapAround, eListboxPythonMultiContent)
		# Check skin
		if Skn == "FHD":
			self.l.setItemHeight(48)
			self.l.setFont(0, gFont('Regular', 27))
		elif Skn == "HD":
			self.l.setItemHeight(40)
			self.l.setFont(0, gFont('Regular', 21))
		else:
			self.l.setItemHeight(32)
			self.l.setFont(0, gFont("Regular", 20))
		self.selection = selection

	def postWidgetCreate(self, instance):
		MenuList.postWidgetCreate(self, instance)
		self.moveToIndex(self.selection)


class DreamCCAuto(object):
	def __init__(self):
		self.readCurrent()

	def readCurrent(self):
		current = None
		try:
			clist = open("/etc/clist.list", "r")
		except:
			return None
		if clist is not None:
			for line in clist:
				current = line
			clist.close()
		scriptliste = []
		path = "/usr/script/cam/"
		for root, dirs, files in os_walk(path):
			for name in files:
				scriptliste.append(name)
		for lines in scriptliste:
			dat = path + lines
			datei = open(dat, "r")
			for line in datei:
				if line[0:3] == "OSD":
					nam = line[5:len(line) - 2]
					if current == nam:
						system(dat + " cam_res &")
			datei.close()


class DreamCC(Screen):
	global Skn
	sz_w = getDesktop(0).size().width()
	# if sz_w == 1280:
	if sz_w == 1920:
		Skn = "FHD"
	elif sz_w == 1280:
		Skn = "HD"
	else:
		Skn = "SD"

	if Skn == "FHD":
		skin = """
			<screen name="DreamCC" position="0,0" size="1920,1080" title="PurCamd Manager" flags="wfNoBorder" backgroundColor="#50313131">
				<widget source="Title" render="Label" position="210,140" size="1500,68" zPosition="-1" halign="center" font="Bold; 36" backgroundColor="#0e6583" transparent="1" valign="center" />
				<ePixmap name="bPPodloga" position="210,140" size="1500,820" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/back_mon_empty.png" zPosition="-10" />
				<ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/chip.png" position="1567,284" size="90,70" zPosition="1" />
				<eLabel name="" position="1542,372" size="145,50" font="Regular; 28" valign="center" halign="center" backgroundColor="#171717" text="OK" />
				<eLabel name="" position="1542,435" size="145,50" font="Regular; 28" valign="center" halign="center" backgroundColor="#171717" text="Exit" />
				<widget name="menu" position="250,282" size="608,465" scrollbarMode="showOnDemand" font="Regular; 28" itemHeight="48" transparent="1" backgroundColor="#171717" selectionPixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/selection.png" backgroundPixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/separator_48.png" scrollbarSliderPicture="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/bar_01.png" />
				<ePixmap pixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/buttons.png" position="214,893" size="1489,56" alphatest="blend" zPosition="100" />
				<eLabel name="" position="235,893" size="354,56" zPosition="1" font="Regular; 28" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Stop" />
				<eLabel name="" position="602,893" size="354,56" zPosition="1" font="Regular; 28" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Start" />
				<eLabel name="" position="1336,893" size="354,56" zPosition="1" font="Regular; 28" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Install" />
				<eLabel name="" position="969,893" size="354,56" zPosition="1" font="Regular; 28" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Cron Manager" />
				<eLabel name="" position="915,240" size="574,35" transparent="1" halign="center" text="ECM Info" zPosition="2" font="Regular; 27" />
				<eLabel name="" position="267,240" size="574,35" transparent="1" halign="center" text="CAM" zPosition="2" font="Regular; 27" />
				<widget name="description" position="240,772" size="1273,100" halign="center" valign="center" font="Regular; 26" backgroundColor="#171717" />
				<widget name="ecminfo" position="895,282" size="608,465" zPosition="5" font="Regular; 24" backgroundColor="#171717" scrollbarMode="showOnDemand" />
				<eLabel name="" position="235,227" size="635,529" zPosition="-4" backgroundColor="#171717"/>
				<eLabel name="" position="883,227" size="635,529" zPosition="-5" backgroundColor="#171717"/>
				<eLabel name="" position="235,768" size="1283,107" zPosition="-5" backgroundColor="#171717"/>
				<eLabel name="" position="250,240" size="608,35" backgroundColor="#242424" />
				<eLabel name="" position="895,240" size="608,35" backgroundColor="#242424" />
			</screen>"""
	elif Skn == "HD":
		skin = """
			<screen name="DreamCC" position="0,0" size="1280,720" title="PurCamd Manager" flags="wfNoBorder" backgroundColor="#50313131">
				<widget source="Title" render="Label" position="78,58" size="1123,68" zPosition="-1" halign="center" font="Bold; 30" backgroundColor="#0e6583" transparent="1" valign="center" />
				<ePixmap name="bPPodloga" position="78,58" size="1123,604" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/back_mon_empty.png" zPosition="-10" />
				<widget name="menu" position="105,177" size="517,317" scrollbarMode="showOnDemand" font="Regular; 22" itemHeight="36" transparent="1" backgroundColor="#171717" selectionPixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/selection.png" backgroundPixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/separator_48.png" scrollbarSliderPicture="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/bar_01.png" />
				<eLabel name="" position="91,602" size="260,42" zPosition="1" font="Regular; 22" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Stop" />
				<eLabel name="" position="370,602" size="260,42" zPosition="1" font="Regular; 22" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Start" />
				<eLabel name="" position="926,602" size="260,42" zPosition="1" font="Regular; 22" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Install" />
				<eLabel name="" position="650,602" size="260,42" zPosition="1" font="Regular; 22" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Cron Manager" />
				<eLabel name="" position="655,143" size="517,26" transparent="1" halign="center" text="ECM Info" zPosition="2" font="Regular; 21" />
				<eLabel name="" position="105,143" size="517,26" transparent="1" halign="center" text="CAM" zPosition="2" font="Regular; 21" />
				<widget name="description" position="91,511" size="1095,81" halign="center" valign="center" font="Regular; 21" backgroundColor="#171717" />
				<widget name="ecminfo" position="655,177" size="517,317" zPosition="5" font="Regular; 22" backgroundColor="#171717" scrollbarMode="showOnDemand" />
				<eLabel name="" position="91,136" size="542,370" zPosition="-4" backgroundColor="#171717" />
				<eLabel name="" position="644,135" size="542,370" zPosition="-5" backgroundColor="#171717" />
				<eLabel name="" position="105,141" size="517,30" backgroundColor="#242424" />
				<eLabel name="" position="655,141" size="517,30" backgroundColor="#242424" />
				<eLabel name="" position="650,637" size="260,10" backgroundColor="yellow" />
				<eLabel name="" position="91,637" size="260,10" backgroundColor="red" />
				<eLabel name="" position="926,637" size="260,10" backgroundColor="blue" />
				<eLabel name="" position="370,637" size="260,10" backgroundColor="green" />
			</screen>"""
	else:
		# SD, 4K??? - use HD version
		skin = """
			<screen name="DreamCC" position="0,0" size="1280,720" title="PurCamd Manager" flags="wfNoBorder" backgroundColor="#50313131">
				<widget source="Title" render="Label" position="78,58" size="1123,68" zPosition="-1" halign="center" font="Bold; 30" backgroundColor="#0e6583" transparent="1" valign="center" />
				<ePixmap name="bPPodloga" position="78,58" size="1123,604" pixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/back_mon_empty.png" zPosition="-10" />
				<widget name="menu" position="105,177" size="517,317" scrollbarMode="showOnDemand" font="Regular; 22" itemHeight="36" transparent="1" backgroundColor="#171717" selectionPixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/selection.png" backgroundPixmap="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/separator_48.png" scrollbarSliderPicture="/usr/lib/enigma2/python/Plugins/Extensions/DreamCC/img/bar_01.png" />
				<eLabel name="" position="91,602" size="260,42" zPosition="1" font="Regular; 22" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Stop" />
				<eLabel name="" position="370,602" size="260,42" zPosition="1" font="Regular; 22" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Start" />
				<eLabel name="" position="926,602" size="260,42" zPosition="1" font="Regular; 22" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Install" />
				<eLabel name="" position="650,602" size="260,42" zPosition="1" font="Regular; 22" halign="center" valign="center" backgroundColor="#171717" foregroundColor="#21e2e2e2" text="Cron Manager" />
				<eLabel name="" position="655,143" size="517,26" transparent="1" halign="center" text="ECM Info" zPosition="2" font="Regular; 21" />
				<eLabel name="" position="105,143" size="517,26" transparent="1" halign="center" text="CAM" zPosition="2" font="Regular; 21" />
				<widget name="description" position="91,511" size="1095,81" halign="center" valign="center" font="Regular; 21" backgroundColor="#171717" />
				<widget name="ecminfo" position="655,177" size="517,317" zPosition="5" font="Regular; 22" backgroundColor="#171717" scrollbarMode="showOnDemand" />
				<eLabel name="" position="91,136" size="542,370" zPosition="-4" backgroundColor="#171717" />
				<eLabel name="" position="644,135" size="542,370" zPosition="-5" backgroundColor="#171717" />
				<eLabel name="" position="105,141" size="517,30" backgroundColor="#242424" />
				<eLabel name="" position="655,141" size="517,30" backgroundColor="#242424" />
				<eLabel name="" position="650,637" size="260,10" backgroundColor="yellow" />
				<eLabel name="" position="91,637" size="260,10" backgroundColor="red" />
				<eLabel name="" position="926,637" size="260,10" backgroundColor="blue" />
				<eLabel name="" position="370,637" size="260,10" backgroundColor="green" />
			</screen>"""


	def __init__(self, session, args=0):
		self.skin = DreamCC.skin
		self.session = session
		Screen.__init__(self, session)
		self.index = 0
		self.sclist = []
		self.namelist = []
		self.oldService = self.session.nav.getCurrentlyPlayingServiceReference()
		self["actions"] = ActionMap(["OkCancelActions", "ColorActions"],
									{
										"ok": self.action,
										"cancel": self.close,
										"green": self.action,
										"red": self.stop,
										"yellow": self.CronCAM,	 # yellow button - CAM Cron Manager
										"blue": self.RemoveCAM	# blue button - install/remove cam
									}, -1)
		self.lastCam = self.readCurrent()
		self.softcamlist = []
		self["menu"] = DCCMenu(self.softcamlist)
		self.readScripts()

		# ECMInfo stuff Here
		self.timer = eTimer()
		self["ecminfo"] = ScrollLabel()
		if self.listServices not in self.timer.callback:
			self.timer.callback.append(self.listServices)
		#		self.timer.callback.append(self.listServices)
		self.timer.start(50, True)
		# ECMInfo End Here

		self["menu"].onSelectionChanged.append(self.updateSummary)
		self.onShown.append(self.updateSummary)

		# Description - Start Here
		self["description"] = Label()
		if str(self.lastCam) == "no":
			self["description"].setText(_("Your Cam is stopped \n To start one please choose one from the list and press Green button"))
		else:
			self["description"].setText(
				_("Your Cam is active \n To stop active Cam please press Red button. To restart active Cam press OK button \n To configure auto-restart press "
				  "Yellow button"))

	# Description - End Here

	# Install/Remove CAM - Start Here
	def RemoveCAM(self):
		# try:
		# from Plugins.Extensions.pManager.camdinstaller import CamdInstall #pozovi direktno funkciju, ne klasu
		# except Exception, e:
		# print e
		# #return
		# CamdInstall(self.session)
		# Install/Remove CAM - End Here
		try:
			from Plugins.Extensions.pManager.FNCcamdInstall import FNCcamdInstall  # modal open are allowed only from a screen which is modal!
			FNCcamdInstall(self.session)
		except Exception as e:
			print(e)

	# Auto restart CAM (Cron) - Start Here
	def CronCAM(self):
		try:
			from Plugins.Extensions.pManager.camrestart import PBCamRestart
		except Exception as e:
			print(e)
		# return
		self.session.open(PBCamRestart)

	# Auto restart CAM (Cron) - End Here

	def getLastIndex(self):
		a = 0
		if len(self.namelist) > 0:
			for x in self.namelist:
				if x == self.lastCam:
					return a
				else:
					a += 1
		else:
			return -1
		return -1

	def action(self):
		self.session.nav.playService(None)
		last = self.getLastIndex()
		var = self["menu"].getSelectionIndex()
		if last > -1:
			if last == var:
				system("wget -O - \"http://127.0.0.1/web/message?text=Restarting CAM...&type=1&timeout=7\" 2>/dev/null&")
				system("/usr/script/cam/" + self.sclist[var] + " cam_res &")
			else:
				system("/usr/script/cam/" + self.sclist[last] + " cam_down &")
				system("/usr/script/cam/" + self.sclist[var] + " cam_up &")
		else:
			if len(self.sclist) == 0:
				self.session.nav.playService(self.oldService)
				self.session.open(MessageBox, _("What the hell you would start?"), type=MessageBox.TYPE_INFO, timeout=5)
				return
			else:
				system("wget -O - \"http://127.0.0.1/web/message?text=Starting CAM...&type=1&timeout=7\" 2>/dev/null&")
				system("/usr/script/cam/" + self.sclist[var] + " cam_up &")
			if last != var:
				self.lastCam = self["menu"].l.getCurrentSelection()[1][7]
				self.writeFile()
		self.readScripts()
		self.session.nav.playService(self.oldService)
		# Description - Start Here
		self["description"].setText(
			_("Your Cam is active \n To stop active Cam please press Red button. To restart active Cam press OK button \n To configure auto-restart press "
			  "Yellow button"))

	# Description - End Here

	def writeFile(self):
		if not self.lastCam is None:
			clist = open("/etc/clist.list", "w")
			clist.write(self.lastCam)
			clist.close()

	def stop(self):
		self.session.nav.playService(None)
		last = self.getLastIndex()
		if last > -1:
			system("/usr/script/cam/" + self.sclist[last] + " cam_down &")
		else:
			self.session.nav.playService(self.oldService)
			self.session.open(MessageBox, _("What the hell you would stop?"), type=MessageBox.TYPE_INFO, timeout=5)
			return
		self.lastCam = "no"
		self.writeFile()
		system("sleep 1")
		self.readScripts()
		self.session.nav.playService(self.oldService)
		# Description - Start Here
		self["description"].setText(_("Your Cam is stopped \n To start one please choose one from the list and press Green button"))

	# Description - End Here

	def readScripts(self):
		self.index = 0
		scriptliste = []
		pliste = []
		path = "/usr/script/cam/"
		for root, dirs, files in os_walk(path):
			for name in files:
				scriptliste.append(name)
		self.sclist = scriptliste
		i = len(self.softcamlist)
		del self.softcamlist[0:i]
		for lines in scriptliste:
			dat = path + lines
			datei = open(dat, "r")
			for line in datei:
				if line[0:3] == "OSD":
					nam = line[5:len(line) - 2]
					if not self.lastCam is None:
						if nam == self.lastCam:
							self.softcamlist.append(DreamCCExtra(name=nam, index=self.index, isActive=True))
						else:
							self.softcamlist.append(DreamCCExtra(name=nam, index=self.index, isActive=False))
						self.index += 1
					else:
						self.softcamlist.append(DreamCCExtra(name=nam, index=self.index, isActive=False))
						self.index += 1
					pliste.append(nam)
			datei.close()
			self["menu"].setList(self.softcamlist)
			self.namelist = pliste

	# Not Important right now, later do something with this :)
	# print "CamCount" + str(self.index)

	def readCurrent(self):
		try:
			clist = open("/etc/clist.list", "r")
		except:
			return None
		lastcam = "nothing"
		if not clist is None:
			for line in clist:
				lastcam = line
			clist.close()
		return lastcam

	def createSummary(self):
		return DreamCCLCDScreen

	# ECMInfo stuff start Here
	def listServices(self):
		list = "\n"
		prev_mtime = 0
		if fileExists("/tmp/ecm.info"):
			try:
				st = stat("/tmp/ecm.info")
				if st.st_size > 0 and prev_mtime < st.st_mtime:
					fdd = open("/tmp/ecm.info", "r")
					for line in fdd:
						list += line
					fdd.close()
			except:
				pass
		self["ecminfo"].setText(list)
		self.timer.start(2000, True)

	# ECMInfo stuff end Here

	def updateSummary(self):
		if len(self.sclist) == 0:
			return
		else:
			text = ""
			status = ""
			selection = self["menu"].getCurrent()
			text = selection[1][7]
			if text == self.lastCam:
				status = _("running")
			else:
				status = _("stopped")
			self.summaries.setText(text, 1)
			self.summaries.setText(status, 2)


class DreamCCLCDScreen(Screen):
	skin = (
		"""<screen name="DreamCCLCDScreen" position="0,0" size="132,64" id="1">
			<widget name="plugin" position="4,0" size="132,35" font="Regular;16"/>
			<widget name="listentry" position="4,36" size="132,14" font="Regular;10"/>
			<widget name="status" position="4,49" size="132,14" font="Regular;10"/>
		</screen>""",
		"""<screen name="DreamCCLCDScreen" position="0,0" size="96,64" id="2">
			<widget name="plugin" position="0,0" size="96,35" font="Regular;14"/>
			<widget name="listentry" position="0,36" size="96,14" font="Regular;10"/>
			<widget name="status" position="0,49" size="96,14" font="Regular;10"/>
		</screen>""")

	def __init__(self, session, parent):
		Screen.__init__(self, session)
		self["plugin"] = Label("DreamCC")
		self["listentry"] = Label("test")
		self["status"] = Label("")

	def setText(self, text, line):
		if line == 1:
			self["listentry"].setText(text)
		if line == 2:
			self["status"].setText(text)
