#!/bin/sh
#
# 2025 - Franc (PurE2)

if tty > /dev/null ; then
   RED='-e \e[00;31m'
   GREEN='-e \e[00;32m'
   YELLOW='-e \e[01;33m'
   BLUE='-e \e[00;34m'
   PURPLE='-e \e[01;31m'
   WHITE='-e \e[00;37m'
else
   RED='\c00??0000'
   GREEN='\c0000??00'
   YELLOW='\c00????00'
   BLUE='\c0000????'
   PURPLE='\c00?:55>7'
   WHITE='\c00??????'
fi

case "$1" in
tcpinfo)
        echo -n $BLUE
        printf "\n%s\n" "Please wait... Collecting data... \n"
        echo -n $YELLOW
        printf "%-24s %-24s %s\n\n" "Local Address" "Foreign Address" "PID/Program name"
        netstat -tpn | tail +3 | awk -F' '  '{printf "%-24s %-24s %s\n", $4, $5, $7}'
        echo -n $WHITE
        printf "\n"
        ;;

general)
        echo -n $BLUE
        printf "\n%s\n" "Collecting general network info... "
        echo -n $YELLOW

        # Local IP
        privateIP=$(ifconfig | grep 'inet addr:' | grep -v '127.0.0.1' | cut -d: -f2 | awk '{print $1}')
        # MAC
        macADR=$(ifconfig | grep 'HWaddr' | awk '{print $5}')
        # MTU
        mtuSIZE=$(ifconfig | grep 'MTU:' | sed 's/.*MTU://')
        # Initial RX/TX bytes
        rx1=$(ifconfig | grep 'RX bytes:' | head -n 1 | awk -F: '{print $2}' | awk '{print $1}')
        tx1=$(ifconfig | grep 'TX bytes:' | head -n 1 | awk -F: '{print $3}' | awk '{print $1}')
        # Gateway
        gatewayIP=$(ip route | awk '/default/ {print $3}')
        # Public IP
        publicIP=$(wget -q -O - http://checkip.dyndns.org | sed -e 's/.*Current IP Address: //' -e 's/<.*$//')
        # Out-of-order segments
        ofoSEG=$(dmesg | grep 'ofo' -c)

        printf "\n%-35s %-20s\n"  "Local IP address is :" "$privateIP"
        printf "%-35s %-20s\n"  "Public IP address is :" "$publicIP"
        printf "%-35s %-20s\n"  "Gateway/Router IP address is :" "$gatewayIP"
        printf "%-35s %-20s\n"  "MAC of your STB is :" "$macADR"
        printf "%-35s %-20s\n"  "Max transmission unit :" "$mtuSIZE"
        printf "%-35s %-20s\n"  "Out of order segments :" "$ofoSEG"

        # Live RX/TX throughput for 3 intervals of 1 second
        printf "\n%-20s %-20s\n" "RX rate (KiB/s)" "TX rate (KiB/s)"
        for i in 1 2 3; do
            sleep 1
            rx2=$(ifconfig | grep 'RX bytes:' | head -n 1 | awk -F: '{print $2}' | awk '{print $1}')
            tx2=$(ifconfig | grep 'TX bytes:' | head -n 1 | awk -F: '{print $3}' | awk '{print $1}')
            rx_rate=$(( (rx2 - rx1) / 1024 ))
            tx_rate=$(( (tx2 - tx1) / 1024 ))
            printf "%-20s %-20s\n" "$rx_rate" "$tx_rate"
            rx1=$rx2
            tx1=$tx2
        done

        echo -n $WHITE
        printf "\n"
        ;;

speed)
        echo -n $BLUE
        printf "%s\n" "Please be patient for a while, checking download speed"
        printf "Downloading 100MB for test... : \n"

        timeStart=$(date +%s)
        wget -q -O/dev/null https://ash-speed.hetzner.com/100MB.bin
        timeEnd=$(date +%s)

        time_diff=$(( $timeEnd - $timeStart ))
        rx_size=104857600  # 100 MB in bytes

        if [[ "${time_diff}" -gt 0 ]]; then
            rx_rate=$(( rx_size / time_diff ))
        else
            rx_rate=$rx_size
            time_diff=1
        fi

        rx_kib=$(( rx_rate >> 10 ))
        echo -n $YELLOW
        printf "Approximate download speed: %i KiB/second\n" "$rx_kib"
        printf "Downloaded 100MB in %i seconds (%i%% of max)\n" "$time_diff" 100

        echo -n $BLUE
        printf "\n%s\n" "Checking ping response..."
        ping -q -w 10 8.8.8.8 > "/tmp/pResult.tmp"
        echo -n $YELLOW
        tail -n +3 "/tmp/pResult.tmp"
        gatewayIP="$(netstat -rn | grep 'UG' | awk '{print $2}')"
        echo -n $BLUE
        printf "\n%s\n" "Checking ping to your router..."
        echo -n $YELLOW
        ping -q -w 5 "$gatewayIP" > "/tmp/pResult.tmp"
        tail -n +3 "/tmp/pResult.tmp"
        rm -f "/tmp/pResult.tmp"

        echo -n $WHITE
        printf "\n"
        ;;

misc)
        printf "%-24s %-24s %s\n\n" "Not used" "at the moment" "dummy placeholder"
        ;;
esac
