# -*- coding: utf-8 -*- 
# Autor: Franc - 2025
from .__init__ import _

from enigma import quitMainloop, eTimer
from Screens.MessageBox import MessageBox
from Screens.Ipkg import Ipkg
from Components.Ipkg import IpkgComponent


class InstallSomething:

    def __init__(self, session, url_to_download):
        self.session = session
        self.cmdList = []
        self._timer = None
        for item in url_to_download:
            print('----INSTALL SOMETHING---item ', item)
            self.cmdList.append((IpkgComponent.CMD_INSTALL, {'package': item}))

    # -------------------------------------------------
    # DAJ VREMENA IPKG-U DA SE INICIJLIZIRA (500ms DOVOLJNO)
    # -------------------------------------------------
    def __install__(self):
        self.__startDelayedInstall(with_restart=False)

    def __installRST__(self):
        self.__startDelayedInstall(with_restart=True)

    # -------------------------------------------------
    # TIMER DELAY
    # -------------------------------------------------
    def __startDelayedInstall(self, with_restart):
        self._with_restart = with_restart
        self._timer = eTimer()
        self._timer.callback.append(self.__doInstall)
        self._timer.start(500, True)  # 500ms delay

    def __doInstall(self):
        if self._with_restart:
            self.session.openWithCallback(self.__restartMessage__, Ipkg, cmdList=self.cmdList)
        else:
            self.session.open(Ipkg, cmdList=self.cmdList)

    # -------------------------------------------------
    # RESTART FLOW
    # -------------------------------------------------
    def __restartMessage__(self):
        self.session.openWithCallback(self.__restartGUI__, MessageBox, _('Restart Enigma2 to apply the changes?'), MessageBox.TYPE_YESNO, default=True)

    def __restartGUI__(self, callback=None):
        if callback == True:
            quitMainloop(3)
        elif callback == False:
            pass

    # -------------------------------------------------
    # ENTRY POINT
    # -------------------------------------------------
    def install(self, opkg_update=False, with_restart=False):
        if opkg_update:
            from Screens.Console import Console as myConsole
            if with_restart:
                self.session.open(myConsole, _('Downloading...'), ['echo ' + _('Please wait') + '\n echo ' + _('Updating...') + '\n echo \n', 'opkg update'],
                                  finishedCallback=self.__installRST__, closeOnSuccess=True)
            else:
                self.session.open(myConsole, _('Downloading...'), ['echo ' + _('Please wait') + '\n echo ' + _('Updating...') + '\n echo \n', 'opkg update'],
                                  finishedCallback=self.__install__, closeOnSuccess=True)
        elif with_restart:
            self.__installRST__()
        else:
            self.__install__()
