from __future__ import absolute_import

import gettext
from os import environ as os_environ

from Components.Language import language

from .settings import _PLUGIN_PATH, _FOLDER_NAME

myPlugin = _FOLDER_NAME  # example: WAZZupFNC


def localeInit():
    os_environ["LANGUAGE"] = language.getLanguage()[:2]
    gettext.bindtextdomain(myPlugin, (_PLUGIN_PATH + "/locale"))


def _(txt):
    t = gettext.dgettext(myPlugin, txt)
    if t == txt:
        t = gettext.gettext(txt)
    return t


localeInit()
language.addCallback(localeInit)
