# -*- coding: UTF-8 -*-
# Uklonjen from __future__ import absolute_import jer je suvišan u Pythonu 3.9+
import os
import re

from ..seeker import SubtitlesDownloadError, SubtitlesErrors
# Uklonjen six.moves i ažuriran uvoz na standardne Py3 module
import urllib.request
import urllib.parse
from http.cookiejar import CookieJar # Zamjena za six.moves.http_cookiejar

from ..utilities import log


main_url = "http://www.italiansubs.net/"

#====================================================================================================================
# Regular expression patterns
#====================================================================================================================

#<input type="hidden" name="return" value="aHR0cDovL3d3dy5pdGFsaWFuc3Vicy5uZXQv" /><input type="hidden" name="c10b48443ee5730c9b5a0927736bd09f" value="1" />
unique_pattern = '<input type="hidden" name="return" value="([^\n\r\t ]+?)" /><input type="hidden" name="([^\n\r\t ]+?)" value="([^\n\r\t ]+?)" />'
#<a href="http://www.italiansubs.net/index.php?option=com_remository&amp;Itemid=6&amp;func=select&amp;id=1170"> Castle</a>
show_pattern = '<a href="http://www\.italiansubs\.net/(index.php\?option=com_remository&amp;Itemid=\d+&amp;func=select&amp;id=[^\n\r\t ]+?)"> %s</a>'
#href="http://www.italiansubs.net/index.php?option=com_remository&amp;Itemid=6&amp;func=select&amp;id=1171"> Stagione 1</a>
season_pattern = '<a href="http://www\.italiansubs\.net/(index.php\?option=com_remository&amp;Itemid=\d+?&amp;func=select&amp;id=[^\n\r\t ]+?)"> Stagione %s</a>'
#<img src='http://www.italiansubs.net/components/com_remository/images/folder_icons/category.gif' width=20 height=20><a name="1172"><a href="http://www.italiansubs.net/index.php?option=com_remository&amp;Itemid=6&amp;func=select&amp;id=1172"> 720p</a>
category_pattern = '<img src=\'http://www\.italiansubs\.net/components/com_remository/images/folder_icons/category\.gif\' width=20 height=20><a name="[^\n\r\t ]+?"><a href="http://www\.italiansubs\.net/(index.php\?option=com_remository&amp;Itemid=\d+?&amp;func=select&amp;id=[^\n\r\t ]+?)"> ([^\n\r\t]+?)</a>'
#<a href="http://www.italiansubs.net/index.php?option=com_remository&amp;Itemid=6&amp;func=fileinfo&amp;id=7348">Dexter 3x02</a>
subtitle_pattern = '<a href="http://www\.italiansubs\.net/(index.php\?option=com_remository&amp;Itemid=\d+?&amp;func=fileinfo&amp;id=([^\n\r\t ]+?))">(%s %sx%02d.*?)</a>'
#<a href='http://www.italiansubs.net/index.php?option=com_remository&amp;Itemid=6&amp;func=download&amp;id=7228&amp;chk=5635630f675375afbdd6eec317d8d688&amp;no_html=1'>
subtitle_download_pattern = '<a href=\'http://www\.italiansubs\.net/(index\.php\?option=com_remository&amp;Itemid=\d+?&amp;func=download&amp;id=%s&amp;chk=[^\n\r\t ]+?&amp;no_html=1\')>'


#====================================================================================================================
# Functions
#====================================================================================================================

def geturl(url):
    log(__name__, f" Getting url: {url}")
    try:
        # Zamijenjeno urllib.urlopen s urllib.request.urlopen (Py3)
        response = urllib.request.urlopen(url)
        content = response.read() # Content je bytes u Py3
    except:
        log(__name__, f" Failed to get url:{url}")
        content = None
    return content


def login(username, password):
    log(__name__, f" Logging in with username '{username}' ...")
    content = geturl(main_url + 'index.php')
    if content is not None:
        # Radi se pretraga u bajtovima
        match = re.search(b'logouticon.png', content, re.IGNORECASE | re.DOTALL)
        if match:
            return 1
        else:
            # PROMJENA: pattern se mora enkodirati u bytes za pretragu
            match = re.search(unique_pattern.encode('utf-8'), content, re.IGNORECASE | re.DOTALL)
            if match:
                # PROMJENA: grupe se moraju dekodirati u stringove
                return_value = match.group(1).decode('utf-8')
                unique_name = match.group(2).decode('utf-8')
                unique_value = match.group(3).decode('utf-8')
                
                # Korišteno urllib.parse.urlencode (Py3)
                login_postdata = urllib.parse.urlencode({
                    'username': username, 
                    'passwd': password, 
                    'remember': 'yes', 
                    'Submit': 'Login', 
                    'option': 'com_user', 
                    'task': 'login', 
                    'silent': 'true', 
                    'return': return_value, 
                    unique_name: unique_value
                })
                
                # Zamijenjeno six.moves.http_cookiejar.CookieJar s http.cookiejar.CookieJar (Py3)
                cj = CookieJar()
                
                # Korišteno urllib.request.build_opener (Py3)
                my_opener = urllib.request.build_opener(urllib.request.HTTPCookieProcessor(cj))
                my_opener.addheaders = [('Referer', main_url)]
                urllib.request.install_opener(my_opener)
                
                # PROMJENA: post data se mora enkodirati u bytes za slanje
                request = urllib.request.Request(main_url + 'index.php', login_postdata.encode('utf-8'))
                
                # Res je bytes
                response = urllib.request.urlopen(request).read()
                
                # Radi se pretraga u bajtovima
                match = re.search(b'logouticon.png', response, re.IGNORECASE | re.DOTALL)
                if match:
                    return 1
                else:
                    return 0
    else:
        return 0


def search_subtitles(file_original_path, title, tvshow, year, season, episode, set_temp, rar, lang1, lang2, lang3, stack): #standard input
    subtitles_list = []
    msg = ""
    # Python 3 preferira eksplicitne provjere
    if len(tvshow) > 0:
        italian = 0
        content = geturl(main_url + 'index.php?option=com_remository&Itemid=6')
        if content is not None:
            # PROMJENA: pattern se mora enkodirati u bytes za pretragu
            search_pattern = (show_pattern % tvshow).encode('utf-8')
            match = re.search(search_pattern, content, re.IGNORECASE | re.DOTALL)
            
            if match is None and tvshow[-1] == ")":
                log(__name__, f" Year Bug? '{tvshow}'")
                tvshow = tvshow[:-7]
                search_pattern = (show_pattern % tvshow).encode('utf-8')
                match = re.search(search_pattern, content, re.IGNORECASE | re.DOTALL)
                
            if match:
                log(__name__, f" Tv show '{tvshow}' found")
                # PROMJENA: grupa se mora dekodirati
                content = geturl(main_url + match.group(1).decode('utf-8'))
                
                if content is not None:
                    # PROMJENA: pattern se mora enkodirati u bytes za pretragu
                    search_pattern = (season_pattern % season).encode('utf-8')
                    match = re.search(search_pattern, content, re.IGNORECASE | re.DOTALL)
                    
                    if match:
                        log(__name__, f" Season {season} of tv show '{tvshow}' found")
                        category = 'normal'
                        # PROMJENA: grupa se mora dekodirati
                        categorypage = match.group(1).decode('utf-8')
                        content = geturl(main_url + categorypage)
                        
                        if content is not None:
                            # PROMJENA: pattern se mora enkodirati u bytes za pretragu
                            subtitle_search_pattern = (subtitle_pattern % (tvshow, int(season), int(episode))).encode('utf-8')
                            for matches in re.finditer(subtitle_search_pattern, content, re.IGNORECASE | re.DOTALL):
                                # PROMJENA: grupe se moraju dekodirati
                                filename = matches.group(3).decode('utf-8')
                                id = matches.group(2).decode('utf-8')
                                log(__name__, f" Adding '{filename}' to list of subtitles")
                                subtitles_list.append({'rating': '0', 'no_files': 1, 'filename': filename, 'sync': False, 'id': id, 'link': categorypage, 'language_flag': 'flags/it.gif', 'language_name': 'Italian'})
                            
                            # PROMJENA: pattern se mora enkodirati u bytes za pretragu
                            for matches in re.finditer(category_pattern.encode('utf-8'), content, re.IGNORECASE | re.DOTALL):
                                # PROMJENA: grupe se moraju dekodirati
                                categorypage = matches.group(1).decode('utf-8')
                                category = matches.group(2).decode('utf-8')
                                log(__name__, f" Page for category '{category}' found")
                                content = geturl(main_url + categorypage)
                                
                                if content is not None:
                                    # PROMJENA: pattern se mora enkodirati u bytes za pretragu
                                    subtitle_search_pattern = (subtitle_pattern % (tvshow, int(season), int(episode))).encode('utf-8')
                                    for matches in re.finditer(subtitle_search_pattern, content, re.IGNORECASE | re.DOTALL):
                                        # PROMJENA: grupe se moraju dekodirati
                                        id = matches.group(2).decode('utf-8')
                                        filename = matches.group(3).decode('utf-8')
                                        log(__name__, f" Adding '{filename} ({category})' to list of subtitles")
                                        # Koristimo f-string za lakše formiranje imena datoteke
                                        subtitles_list.append({'rating': '0', 'no_files': 1, 'filename': f"{filename} ({category})", 'sync': False, 'id': id, 'link': categorypage, 'language_flag': 'flags/it.gif', 'language_name': 'Italian'})
                    else:
                        log(__name__, f" Season {season} of tv show '{tvshow}' not found")
                        msg = f"Season {season} of tv show '{tvshow}' not found"
            else:
                log(__name__, f" Tv show '{tvshow}' not found.")
                msg = f"Tv show '{tvshow}' not found"
    else:
        msg = "Won't work, Itasa is only for tv shows."
    return subtitles_list, "", msg #standard output


def download_subtitles(subtitles_list, pos, zip_subs, tmp_sub_dir, sub_folder, session_id): #standard input
    # settings_provider nije definiran globalno, moramo ga definirati/pretpostaviti da dolazi odnekud
    # Prema kontekstu, settings_provider je vjerojatno globalna varijabla ili se prosljeđuje
    # Ostavljamo kako je, pretpostavljajući da je definiran u modulu koji uvozi ovu funkciju.
    # Da bi kod radio samostalno, morali bismo ga dobiti kao argument ili definirati.
    # Budući da je ovo prilagodba, zadržavamo postojeću strukturu poziva.
    
    username = settings_provider.getSetting("ITuser") 
    password = settings_provider.getSetting("ITpass")
    
    if username == "" or password == "":
        raise SubtitlesDownloadError(SubtitlesErrors.NO_CREDENTIALS_ERROR, "not provided credentials")
        
    if login(username, password):
        log(__name__, " Login successful")
        id = subtitles_list[pos]["id"]
        link = subtitles_list[pos]["link"]
        content = geturl(main_url + link)
        
        # PROMJENA: pattern se mora enkodirati u bytes za pretragu
        match = re.search((subtitle_download_pattern % id).encode('utf-8'), content, re.IGNORECASE | re.DOTALL)
        
        if match:
            language = subtitles_list[pos]["language_name"]
            # PROMJENA: grupa se mora dekodirati
            download_url = main_url + match.group(1).decode('utf-8')
            log(__name__, f" Fetching subtitles using url {download_url}")
            content = geturl(download_url)
            
            if content is not None:
                header = content[:4]
                
                # PROMJENA: bytes literali za usporedbu
                if header == b'Rar!':
                    local_tmp_file = os.path.join(tmp_sub_dir, "undertexter.rar")
                    packed = True
                elif header == b'PK\x03\x04': # ZIP header
                    local_tmp_file = os.path.join(tmp_sub_dir, "undertexter.zip")
                    packed = True
                else: # never found/downloaded an unpacked subtitles file, but just to be sure ...
                    local_tmp_file = os.path.join(tmp_sub_dir, "undertexter.srt") # assume unpacked subtitels file is an '.srt'
                    packed = False
                    
                subs_file = local_tmp_file
                log(__name__, f" Saving subtitles to '{local_tmp_file}'")
                
                try:
                    # 'wb' je ispravan mod za pisanje bajtova
                    with open(local_tmp_file, "wb") as local_file_handle:
                        local_file_handle.write(content)
                except:
                    log(__name__, f" Failed to save subtitles to '{local_tmp_file}'")
                    raise # Rethrow exception if save fails
                    
                return packed, language, subs_file #standard output
    
    log(__name__, " Login to Itasa failed. Check your username/password at the addon configuration.")
    raise SubtitlesDownloadError(SubtitlesErrors.INVALID_CREDENTIALS_ERROR, "provided invalid credentials")
    
    