# -*- coding: UTF-8 -*-
# Uklonjen from __future__ import absolute_import
import os
import re
# Standardni Py3 uvoz urllib modula
import urllib.request
import urllib.parse

from ..utilities import log


main_url = "http://www.subtitles.gr"
debug_pretext = "subtitles.gr"


def get_url(url, referer=None):
    if referer is None:
        # Koristimo standardni Py3 User-agent
        headers = {'User-agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36'}
    else:
        headers = {'User-agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/116.0.0.0 Safari/537.36', 'Referer': referer}
    
    # Koristimo urllib.request
    req = urllib.request.Request(url, None, headers)
    response = urllib.request.urlopen(req)
    content = response.read() # Content je bytes
    response.close()
    content = content.replace(b'\n', b'') # Rukovanje s bytes literalima
    return content


def get_rating(downloads):
    # Downloads se prosljeđuje kao string, pretvaramo ga u int
    try:
        rating = int(downloads)
    except ValueError:
        return 0
        
    if (rating < 50):
        rating = 1
    elif (rating >= 50 and rating < 100):
        rating = 2
    elif (rating >= 100 and rating < 150):
        rating = 3
    elif (rating >= 150 and rating < 200):
        rating = 4
    elif (rating >= 200 and rating < 250):
        rating = 5
    elif (rating >= 250 and rating < 300):
        rating = 6
    elif (rating >= 300 and rating < 350):
        rating = 7
    elif (rating >= 350 and rating < 400):
        rating = 8
    elif (rating >= 400 and rating < 450):
        rating = 9
    elif (rating >= 450):
        rating = 10
    return rating


def search_subtitles(file_original_path, title, tvshow, year, season, episode, set_temp, rar, lang1, lang2, lang3, stack): #standard input
    subtitles_list = []
    msg = ""

    # Fiksirana logika za TVShow/Movie pretragu
    if len(tvshow) == 0 and year: # Movie
        searchstring = f"{title} ({year})"
    elif len(tvshow) > 0 and season and episode: # TVShow
        searchstring = f"{tvshow} S{int(season):02d}E{int(episode):02d}"
    # Ovaj elif (Movie not in Library) je logički redundantan ako je TVShow prisutan.
    # Pretpostavljamo da je originalna logika bila da se TVShow koristi kao fallback za naslov.
    elif len(tvshow) > 0 and title == tvshow:
        searchstring = f"{tvshow} {int(season):02d}x{int(episode):02d}" 
    else:
        searchstring = title

    log(__name__, f"{debug_pretext} Search string = {searchstring}")
    # Subtitles.gr je grčka stranica, pa pretražujemo samo za grčke titlove
    get_subtitles_list(searchstring, "el", "Greek", subtitles_list) 
    return subtitles_list, "", msg #standard output


def download_subtitles(subtitles_list, pos, zip_subs, tmp_sub_dir, sub_folder, session_id): #standard input
    language = subtitles_list[pos]["language_name"]
    id_link = subtitles_list[pos]["id"]
    
    # Regex na stringu jer je id_link string
    # Cilj je izdvojiti zadnji dio URL-a koji je potreban za download
    try:
        match = re.compile(r'(.+?)/$').findall(id_link)
        if match:
             # Uzimamo zadnji dio bez zadnjeg '/'
            download_id = match[-1].split('/')[-1] 
        else:
            # Fallback ako regex ne radi, uzmi sve nakon zadnjeg '/'
            download_id = id_link.split('/')[-1]
            if not download_id: # ako je id_link završio s '/'
                 download_id = id_link.split('/')[-2]
    except Exception as e:
        log(__name__, f"{debug_pretext} Failed to parse ID link: {e}")
        download_id = id_link.split('/')[-1]

    # Stara download URL struktura s findsubtitles.eu - pretpostavljamo da je još uvijek ispravna
    download_url = f'http://www.findsubtitles.eu/getp.php?id={download_id}' 

    try:
        log(__name__, f"{debug_pretext} Getting url: {download_url}")
        response = urllib.request.urlopen(download_url)
        content = response.read() # content je bytes
        file_type = content[:4] # Prva 4 bajta za provjeru tipa datoteke
        response.close()
    except Exception as e:
        log(__name__, f"{debug_pretext} Failed to get download url:{download_url}. Error: {e}")
        # Vraćamo True jer je to standardni output, iako je preuzimanje neuspješno. 
        # Modul koji poziva ovu funkciju treba obraditi neuspjeh preuzimanja.
        return True, language, "" 

    local_tmp_file = None
    # Provjera tipa datoteke pomoću bytes literala
    if file_type.startswith(b'Rar!'):
        local_tmp_file = os.path.join(tmp_sub_dir, "subtitlesgr.rar")
    elif file_type.startswith(b'PK\x03\x04'):
        local_tmp_file = os.path.join(tmp_sub_dir, "subtitlesgr.zip")
    else:
        log(__name__, f"{debug_pretext} Failed to get correct content type. Header: {file_type}")
        return True, language, ""

    log(__name__, f"{debug_pretext} Saving subtitles to '{local_tmp_file}'")
    
    # Koristimo 'with' za sigurno rukovanje datotekama
    try:
        with open(local_tmp_file, "wb") as local_file_handle:
            local_file_handle.write(content)
    except Exception as e:
        log(__name__, f"{debug_pretext} Failed to save file: {e}")
        return True, language, ""
        
    # Vraćamo True jer je datoteka spremljena i treba je raspakirati (ako je zip/rar)
    return True, language, local_tmp_file


def get_subtitles_list(searchstring, languageshort, languagelong, subtitles_list):
    # Korištenje urllib.parse.quote_plus za URL kodiranje
    url = f'{main_url}/search.php?name={urllib.parse.quote_plus(searchstring)}&sort=downloads+desc'
    
    try:
        log(__name__, f"{debug_pretext} Getting url: {url}")
        content = get_url(url, referer=main_url) # content je bytes
    except Exception as e:
        log(__name__, f"{debug_pretext} Failed to get url:{url}. Error: {e}")
        return
        
    try:
        log(__name__, f"{debug_pretext} Getting '{languageshort}' subs ...")
        # Korištenje bytes regexa
        subtitles = re.compile(b'(<img src=".+?flags/el.gif".+?</tr>)').findall(content)
    except Exception as e:
        log(__name__, f"{debug_pretext} Failed to get subtitles. Error: {e}")
        return
        
    for subtitle in subtitles:
        filename = ''
        id = ''
        uploader = ''
        downloads = '0'
        rating = 0
        
        try:
            # Svi regexi su bytes, a rezultati dekodirani u string za obradu
            
            # Filename
            filename_match = re.compile(b'title = "(.+?)"').findall(subtitle)
            if filename_match:
                filename = filename_match[0].decode('utf-8').split("subtitles for")[-1].strip()
            
            # ID (link)
            id_match = re.compile(b'href="(.+?)"').findall(subtitle)
            if id_match:
                id = id_match[0].decode('utf-8')
            
            # Uploader
            uploader_match = re.compile(b'class="link_from">(.+?)</a>').findall(subtitle)
            if uploader_match:
                uploader = uploader_match[0].decode('utf-8').strip()
                if uploader == 'movieplace':
                    uploader = 'GreekSubtitles'
                filename = f'[{uploader}] {filename}'
            
            # Downloads
            downloads_match = re.compile(b'class="latest_downloads">(.+?)</td>').findall(subtitle)
            if downloads_match:
                downloads = re.sub(r"\D", "", downloads_match[0].decode('utf-8'))
                if downloads:
                    filename += f' [{downloads} DLs]'
            
            # Rating
            if downloads:
                rating = get_rating(downloads)
            
            # Logika filtriranja uploader-a (pretpostavljamo da su ovi stringovi na grčkom)
            if not (uploader == 'Εργαστήρι Υποτίτλων' or uploader == 'subs4series'):
                log(__name__, f"{debug_pretext} Subtitles found: {filename} (id = {id})")
                subtitles_list.append({
                    'rating': str(rating), 
                    'no_files': 1, 
                    'filename': filename, 
                    'sync': False, 
                    'id': id, 
                    'language_flag': f'flags/{languageshort}.gif', 
                    'language_name': languagelong
                })
        except Exception as e:
            # Ulovite specifičnu grešku ako je potrebno, inače zadržite opći pass
            # log(__name__, f"Error processing subtitle entry: {e}")
            pass
            
    return
    
    