#!/usr/bin/python
# -*- coding: utf-8 -*-
import gettext
import os

from Components.Language import language
from Tools.Directories import resolveFilename, SCOPE_PLUGINS

PluginLanguageDomain = 'MediaPlayer2'
PluginLanguagePath = 'Extensions/MediaPlayer2/locale'


def localeInit():
    lang = language.getLanguage()[:2]
    os.environ['LANGUAGE'] = lang
    print(('[MediaPlayer2] set language to ', lang))
    gettext.bindtextdomain(PluginLanguageDomain, resolveFilename(SCOPE_PLUGINS, PluginLanguagePath))


def _(txt):
    t = gettext.dgettext(PluginLanguageDomain, txt)
    if t == txt:
        print(f'[{PluginLanguageDomain}] fallback to default translation for {txt}')
        t = gettext.gettext(txt)
    return t


localeInit()
language.addCallback(localeInit)
