import gettext
from os import environ as os_environ

from Components.Language import language


def localeInit():
    os_environ["LANGUAGE"] = language.getLanguage()[:2]
    gettext.bindtextdomain("StreamlordFNC", ("/usr/lib/enigma2/python/Plugins/Extensions/StreamlordFNC/locale"))


def _(txt):
    t = gettext.dgettext("StreamlordFNC", txt)
    if t == txt:
        t = gettext.gettext(txt)
    return t


localeInit()
language.addCallback(localeInit)
