# -*- coding: utf-8 -*-

# from __future__ import absolute_import
import os

from .pn_utilities import PNServer, OpensubtitlesHash, \
    calculateSublightHash, __scriptid__
from . import pn_utilities

from ..utilities import log, languageTranslate, normalizeString


from six.moves import urllib
import urllib.error


def Search(item):
    pn_server = PNServer()
    pn_server.Create()
    if item['temp']:
        item['OShash'] = "000000000000"
        item['SLhash'] = "000000000000"
    else:
        item['OShash'] = OpensubtitlesHash(item)
        item['SLhash'] = calculateSublightHash(item['file_original_path'])
        log(__scriptid__, f"xbmc module OShash: {item['OShash']}, SLhash:{item['SLhash']}")

    log(__scriptid__, f"Search for [{os.path.basename(item['file_original_path'])}] by name")
    subtitles_list = pn_server.SearchSubtitlesWeb(item)
    return subtitles_list


def Download(params):
    pn_server = PNServer()
    pn_server.Create()
    url = pn_server.Download(params)
    return url


def search_subtitles(file_original_path, title, tvshow, year, season, episode, set_temp, rar, lang1, lang2, lang3, stack):  # standard input
    pn_utilities.settings_provider = settings_provider
    item = {}
    item['temp'] = False
    item['rar'] = False
    item['year'] = year
    item['season'] = str(season)
    item['episode'] = str(episode)
    item['tvshow'] = tvshow
    item['title'] = title
    item['file_original_path'] = file_original_path
    item['3et_language'] = [languageTranslate(lang1, 0, 1), languageTranslate(lang2, 0, 1), languageTranslate(lang3, 0, 1)]

    if not item['title']:
        log(__scriptid__, "VideoPlayer.OriginalTitle not found")
        item['title'] = normalizeString(os.path.basename(item['file_original_path']))

    if item['episode'].lower().find("s") > -1:  # Check if season is "Special"
        item['season'] = "0"  #
        item['episode'] = item['episode'][-1:]

    if (item['file_original_path'].find("http") > -1):
        item['temp'] = True

    elif (item['file_original_path'].find("rar://") > -1):
        item['rar'] = True
        item['file_original_path'] = os.path.dirname(item['file_original_path'][6:])

    elif (item['file_original_path'].find("stack://") > -1):
        stackPath = item['file_original_path'].split(" , ")
        item['file_original_path'] = stackPath[0][8:]

    return Search(item), "", ""


# def download_subtitles(subtitles_list, pos, zip_subs, tmp_sub_dir, sub_folder, session_id):  # standard input
    # pn_utilities.settings_provider = settings_provider
    # params = subtitles_list[pos]
    # # params["hash"] = params['OShash']
    # params['match'] = params['sync']
    # url = Download(params)
    # if url != None:
        # local_file = open(zip_subs, "w" + "b")
        # f = urllib.request.urlopen(url)
        # local_file.write(f.read())
        # local_file.close()
    # language = params['language_name']
    # return True, language, ""  # standard output





def download_subtitles(subtitles_list, pos, zip_subs, tmp_sub_dir, sub_folder, session_id):  # standard input
    pn_utilities.settings_provider = settings_provider
    params = subtitles_list[pos]
    # params["hash"] = params['OShash']
    params['match'] = params['sync']
    url = Download(params)
    if url is not None:
        try:
            with urllib.request.urlopen(url, timeout=30) as f:
                with open(zip_subs, "wb") as local_file:
                    local_file.write(f.read())
        except urllib.error.HTTPError as e:
            print(f"HTTPError: {e.code} - {e.reason}")
            return False, None, f"HTTP Error: {e.code} - {e.reason}"
        except urllib.error.URLError as e:
            print(f"URLError: {e.reason}")
            return False, None, f"URL Error: {e.reason}"
        except Exception as e:
            print(f"Unexpected error: {e}")
            return False, None, f"Unexpected error: {e}"

    language = params['language_name']
    return True, language, ""  # standard output
